local playMode = GAMESTATE:GetPlayMode()

local sStage = ""
sStage = GAMESTATE:GetCurrentStage()

if playMode ~= 'PlayMode_Regular' and playMode ~= 'PlayMode_Rave' and playMode ~= 'PlayMode_Battle' then
  sStage = playMode;
end;
local t = Def.ActorFrame {};

-- BG elements
t[#t+1] = Def.Quad {
			InitCommand=cmd(Center;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,Color("Black"));
		};
		
if GAMESTATE:IsCourseMode() then
	t[#t+1] = LoadActor("_base") .. {
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;);
	};
	else
	t[#t+1] = Def.Sprite {
		InitCommand=cmd(Center);
		BeginCommand=cmd(LoadFromCurrentSongBackground);
		OnCommand=function(self)
			self:scaletoclipped(SCREEN_WIDTH,SCREEN_HEIGHT)
			self:diffusealpha(0):zoom(1.3):decelerate(0.5):zoom(1):diffusealpha(1)
		end;
	};
end	
t[#t+1] = Def.ActorFrame {
		LoadActor("_shuriken") .. {
			InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;diffusealpha,0.8);
			OnCommand=cmd(rotationz,10;linear,0.4;rotationz,140;linear,4;rotationz,210);
		};
		LoadActor("_shuriken") .. {
			InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;blend,'BlendMode_Add';diffusealpha,0.3);
			OnCommand=cmd(rotationz,10;linear,0.4;rotationz,140;linear,4;rotationz,210);
		};
		LoadActor("_flare") .. {
			InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;blend,'BlendMode_Add';diffusealpha,1;zoom,0.75);
			OnCommand=cmd(decelerate,4;zoom,0.8;rotationz,15);
		};
		};

t[#t+1] = Def.Quad {
			InitCommand=cmd(Center;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,Color("Black");diffusealpha,0.6);
		};

t[#t+1] = LoadActor("_hex") .. {
			InitCommand=cmd(Center;blend,'BlendMode_Add';);
			OnCommand=cmd(zoom,1.5;diffusealpha,0;smooth,0.3;diffusealpha,1;zoom,1;linear,4;diffusealpha,0;zoom,1.1);
		};	

-- Song title overlay
t[#t+1] = LoadActor("_overlay") .. {
			InitCommand=cmd(Center;blend,'BlendMode_Add';);
			OnCommand=cmd(zoomy,0.2;diffusealpha,0.2;bouncebegin,0.3;diffusealpha,0.8;zoomy,0.4;bouncebegin,0.2;zoomy,0;linear,0.3;diffusealpha,1;zoomy,1;smooth,3;zoomy,0.8;diffusealpha,0.7);
		};		

if not GAMESTATE:IsCourseMode() then		
t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-28);
		OnCommand=cmd(diffusealpha,0;zoomx,0.8;sleep,0.6;decelerate,0.3;diffusealpha,1;zoomx,1;);
		
		LoadFont("Common normal") .. {
				  InitCommand=cmd(maxwidth,300;horizalign,center;zoom,0.75;strokecolor,color("#000000");visible,not GAMESTATE:IsCourseMode(););
				  OnCommand=function(self)
						self:diffuse(color("#FFFFFF"));
					end;
				  CurrentSongChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  CurrentCourseChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  ChangedLanguageDisplayMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  SetCommand=function(self)
					   local song = GAMESTATE:GetCurrentSong();
					   if song then
							self:settext(song:GetGenre()); 
							self:playcommand("Refresh");
						else
							self:settext("");
							self:playcommand("Refresh");
					   end
				  end;
		};
		
		-- Title
		LoadFont("_teko semibold 36px") .. {
				  InitCommand=cmd(maxwidth,270;addy,31;diffuse,color("#FFFEE3");strokecolor,color("#212324");diffusebottomedge,color("#FFE880");horizalign,center;visible,not GAMESTATE:IsCourseMode(););
				  CurrentSongChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  CurrentCourseChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  ChangedLanguageDisplayMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  SetCommand=function(self)
					   local song = GAMESTATE:GetCurrentSong();
					   if song then
							self:settext(song:GetDisplayFullTitle());
							self:playcommand("Refresh");
						else
							self:settext("");
							self:playcommand("Refresh");
					   end
				  end;
		};
		-- Artist
		LoadFont("Common normal") .. {
				  InitCommand=cmd(addy,57;maxwidth,300;horizalign,center;zoom,0.75;strokecolor,color("#000000");visible,not GAMESTATE:IsCourseMode(););
				  OnCommand=function(self)
						self:diffuse(color("#FFFFFF"));
					end;
				  CurrentSongChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  CurrentCourseChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  ChangedLanguageDisplayMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  SetCommand=function(self)
					   local song = GAMESTATE:GetCurrentSong();
					   if song then
							self:settext(song:GetDisplayArtist());
							self:playcommand("Refresh");
						else
							self:settext("");
							self:playcommand("Refresh");
					   end
				  end;
		};

};
end;

t[#t+1] = Def.ActorFrame {
	InitCommand=function(self)
		self:x(SCREEN_CENTER_X)
			if GAMESTATE:IsCourseMode() then
			self:y(SCREEN_CENTER_Y)
			else
			self:y(SCREEN_CENTER_Y+150)
			end;
		end;
	LoadActor( THEME:GetPathG("ScreenStageInformation", "Stage " .. ToEnumShortString(sStage) ) ) .. {
		OnCommand=function(self)
			self:diffusealpha(0):rotationz(-30):zoom(0.3):sleep(0.6):decelerate(0.3):rotationz(0):diffusealpha(1):zoom(0.5)
		end;
	};
};
		
		
-- Flashes
t[#t+1] = Def.ActorFrame {
		Def.Quad {
			InitCommand=cmd(Center;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,Color("White"));
			OnCommand=cmd(diffusealpha,1;smooth,0.3;diffusealpha,0);
		};

		Def.Quad {
			InitCommand=cmd(Center;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,Color("Black"));
			OnCommand=cmd(diffusealpha,0;sleep,4;linear,0.5;diffusealpha,1;sleep,1);
		};
};


t[#t+1] = LoadActor( THEME:GetPathS("_stage","sound")) .. {
        OnCommand=cmd(queuecommand,("Play"));
		PlayCommand=cmd(play);	
		};	

return t